using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Class DlgSelectProvider
	/// </summary>
	public class DlgSelectProvider : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.TextBox txtProvider;
		private System.Windows.Forms.GroupBox grpResults;
		private System.Windows.Forms.ListBox lbResults;
		private System.Windows.Forms.GroupBox grpSearch;
		private System.Windows.Forms.Label lblProvider;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private System.ComponentModel.IContainer components = null;

		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgSelectProvider()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}

		#endregion


		#region properties

		/// <summary>
		/// Get Provider
		/// </summary>
		public string Provider
		{
			get
			{
				return this.lbResults.SelectedItem.ToString();
			}
		}

		#endregion


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectProvider));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpResults = new System.Windows.Forms.GroupBox();
			this.lbResults = new System.Windows.Forms.ListBox();
			this.txtProvider = new System.Windows.Forms.TextBox();
			this.grpSearch = new System.Windows.Forms.GroupBox();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.lblProvider = new System.Windows.Forms.Label();
			this.grpResults.SuspendLayout();
			this.grpSearch.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(342, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Select Provider";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 264);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(186, 255);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(266, 255);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			// 
			// grpResults
			// 
			this.grpResults.AccessibleDescription = "Search Results";
			this.grpResults.AccessibleName = "Search Results";
			this.grpResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpResults.Controls.Add(this.lbResults);
			this.grpResults.Location = new System.Drawing.Point(4, 80);
			this.grpResults.Name = "grpResults";
			this.grpResults.Size = new System.Drawing.Size(334, 168);
			this.grpResults.TabIndex = 1;
			this.grpResults.TabStop = false;
			this.grpResults.Text = "Search Results";
			// 
			// lbResults
			// 
			this.lbResults.AccessibleDescription = "Search Results";
			this.lbResults.AccessibleName = "Search Results";
			this.lbResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lbResults.ItemHeight = 14;
			this.lbResults.Location = new System.Drawing.Point(8, 16);
			this.lbResults.Name = "lbResults";
			this.lbResults.Size = new System.Drawing.Size(318, 144);
			this.lbResults.TabIndex = 3;
			this.lbResults.SelectedIndexChanged += new System.EventHandler(this.lbResults_SelectedIndexChanged);
			// 
			// txtProvider
			// 
			this.txtProvider.AccessibleDescription = "Partial Provider Name";
			this.txtProvider.AccessibleName = "Partial Provider Name";
			this.txtProvider.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProvider.Location = new System.Drawing.Point(120, 16);
			this.txtProvider.Name = "txtProvider";
			this.txtProvider.Size = new System.Drawing.Size(130, 20);
			this.txtProvider.TabIndex = 1;
			this.txtProvider.Text = "";
			this.txtProvider.TextChanged += new System.EventHandler(this.txtProvider_TextChanged);
			// 
			// grpSearch
			// 
			this.grpSearch.AccessibleDescription = "Search Criterion";
			this.grpSearch.AccessibleName = "Search Criterion";
			this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearch.Controls.Add(this.btnSearch);
			this.grpSearch.Controls.Add(this.txtProvider);
			this.grpSearch.Controls.Add(this.lblProvider);
			this.grpSearch.Location = new System.Drawing.Point(4, 32);
			this.grpSearch.Name = "grpSearch";
			this.grpSearch.Size = new System.Drawing.Size(334, 44);
			this.grpSearch.TabIndex = 0;
			this.grpSearch.TabStop = false;
			this.grpSearch.Text = "Search Criterion";
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(250, 14);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 2;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// lblProvider
			// 
			this.lblProvider.Location = new System.Drawing.Point(8, 16);
			this.lblProvider.Name = "lblProvider";
			this.lblProvider.Size = new System.Drawing.Size(120, 20);
			this.lblProvider.TabIndex = 0;
			this.lblProvider.Text = "Partial Provider Name*";
			this.lblProvider.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgSelectProvider
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(342, 280);
			this.Controls.Add(this.grpResults);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpSearch);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(350, 304);
			this.Name = "DlgSelectProvider";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Provider";
			this.Controls.SetChildIndex(this.grpSearch, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpResults, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpResults.ResumeLayout(false);
			this.grpSearch.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		#region methods

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.btnSearch.EnabledButton = false;
			this.btnSearch.Text = "&Search";
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";

			this.ttToolTip.SetToolTip(btnOK, "A provider must be chosen");
		}

		#endregion


		#region events

		private void txtProvider_TextChanged(object sender, System.EventArgs e)
		{
			string providerName = this.txtProvider.Text.Trim();
			for (int i=0; i<providerName.Length; i++)
			{
				if (!Char.IsLetter(providerName, i)) 
				{
					this.ttToolTip.SetToolTip(btnSearch, "Provider name must be all letters");
					return;
				}
			}
			this.btnSearch.EnabledButton = (this.txtProvider.Text.Trim().Length > 0);
		}

		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this.lbResults.Items.Clear();

			// get ordering clinicians (it wouldn't make sense to put this code in the BOL since
			// this form doesn't interact with it at all)
			// BR_73.18
			DataTable dtClinicians =  DAL.VAL.Provider.GetVistaProvider(Common.LogonUser.LogonUserDivisionCode.Trim(), this.txtProvider.Text.Trim().ToUpper());
			foreach (DataRow dtRow in dtClinicians.Rows)
			{
				if (dtClinicians.Columns.Contains(Common.DatabaseConstants.VistALinkColumnNames.ProviderName))
				{
					this.lbResults.Items.Add( dtRow[Common.DatabaseConstants.VistALinkColumnNames.ProviderName].ToString() );	
				}
				else
				{
					MessageBox.Show(Common.StrRes.ValidMsg.Common.DlgSelectProvider().ResString);
				}
			}
		}

		private void lbResults_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = true;
			this.ttToolTip.SetToolTip(btnOK, string.Empty);
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}
		
		#endregion
	
	}
}

